import 'package:flutter/material.dart';
import 'package:font_awesome_flutter/font_awesome_flutter.dart';

/// Not for pro fontawesome icons
/// To use this class, you need to import the package:font_awesome_flutter/font_awesome_flutter.dart
///
class FontAwesomeHelper {
  FontAwesomeHelper._();

  /// [IconData] for a font awesome brand icon from a code point - [fab].
  /// faClass format is [fa-google].
  /// [faClass] can be obtained from fontawesome.com.
  static IconData getIconDataBrands(faClass) =>
      IconDataBrands(_getCode(faClass));

  /// [IconData] for a font awesome solid icon from a code point - [fas].
  /// faClass format is [fa-baseball-ball]
  /// [faClass] can be obtained from fontawesome.com
  static IconData getIconDataSolid(faClass) => IconDataSolid(_getCode(faClass));

  /// [IconData] for a font awesome icon from a code point.
  /// faClass format is [fa-baseball-ball] and stylePrefix is only [fas] and [fab].
  /// Other style prefixes [far], [fal], [fad] are not supported.
  /// [faClass] and [stylePrefix] can be obtained from fontawesome.com.
  static IconData getIconData(
      {required String stylePrefix, required String faClass}) {
    if (stylePrefix == "fas") {
      return IconDataSolid(_getCode(faClass));
    } else if (stylePrefix == "fab") {
      return IconDataBrands(_getCode(faClass));
    } else {
      throw Exception("Invalid style prefix");
    }
  }
}

int _getCode(faClass) {
  final String? code = _faClasses[faClass];
  if (code == null) {
    return int.parse(_faClasses["fa-cubes"]!);
  } else {
    return int.parse(code);
  }
}

final Map<String, String> _faClasses = {
  'fa-500px': '0xf26e',
  'fa-accessible-icon': '0xf368',
  'fa-accusoft': '0xf369',
  'fa-acquisitions-incorporated': '0xf6af',
  'fa-ad': '0xf641',
  'fa-address-book': '0xf2b9',
  'fa-address-card': '0xf2bb',
  'fa-adjust': '0xf042',
  'fa-adn': '0xf170',
  'fa-adobe': '0xf778',
  'fa-adversal': '0xf36a',
  'fa-affiliatetheme': '0xf36b',
  'fa-air-freshener': '0xf5d0',
  'fa-airbnb': '0xf834',
  'fa-algolia': '0xf36c',
  'fa-align-center': '0xf037',
  'fa-align-justify': '0xf039',
  'fa-align-left': '0xf036',
  'fa-align-right': '0xf038',
  'fa-alipay': '0xf642',
  'fa-allergies': '0xf461',
  'fa-amazon': '0xf270',
  'fa-amazon-pay': '0xf42c',
  'fa-ambulance': '0xf0f9',
  'fa-american-sign-language-interpreting': '0xf2a3',
  'fa-amilia': '0xf36d',
  'fa-anchor': '0xf13d',
  'fa-android': '0xf17b',
  'fa-angellist': '0xf209',
  'fa-angle-double-down': '0xf103',
  'fa-angle-double-left': '0xf100',
  'fa-angle-double-right': '0xf101',
  'fa-angle-double-up': '0xf102',
  'fa-angle-down': '0xf107',
  'fa-angle-left': '0xf104',
  'fa-angle-right': '0xf105',
  'fa-angle-up': '0xf106',
  'fa-angry': '0xf556',
  'fa-angrycreative': '0xf36e',
  'fa-angular': '0xf420',
  'fa-ankh': '0xf644',
  'fa-app-store': '0xf36f',
  'fa-app-store-ios': '0xf370',
  'fa-apper': '0xf371',
  'fa-apple': '0xf179',
  'fa-apple-alt': '0xf5d1',
  'fa-apple-pay': '0xf415',
  'fa-archive': '0xf187',
  'fa-archway': '0xf557',
  'fa-arrow-alt-circle-down': '0xf358',
  'fa-arrow-alt-circle-left': '0xf359',
  'fa-arrow-alt-circle-right': '0xf35a',
  'fa-arrow-alt-circle-up': '0xf35b',
  'fa-arrow-circle-down': '0xf0ab',
  'fa-arrow-circle-left': '0xf0a8',
  'fa-arrow-circle-right': '0xf0a9',
  'fa-arrow-circle-up': '0xf0aa',
  'fa-arrow-down': '0xf063',
  'fa-arrow-left': '0xf060',
  'fa-arrow-right': '0xf061',
  'fa-arrow-up': '0xf062',
  'fa-arrows-alt': '0xf0b2',
  'fa-arrows-alt-h': '0xf337',
  'fa-arrows-alt-v': '0xf338',
  'fa-artstation': '0xf77a',
  'fa-assistive-listening-systems': '0xf2a2',
  'fa-asterisk': '0xf069',
  'fa-asymmetrik': '0xf372',
  'fa-at': '0xf1fa',
  'fa-atlas': '0xf558',
  'fa-atlassian': '0xf77b',
  'fa-atom': '0xf5d2',
  'fa-audible': '0xf373',
  'fa-audio-description': '0xf29e',
  'fa-autoprefixer': '0xf41c',
  'fa-avianex': '0xf374',
  'fa-aviato': '0xf421',
  'fa-award': '0xf559',
  'fa-aws': '0xf375',
  'fa-baby': '0xf77c',
  'fa-baby-carriage': '0xf77d',
  'fa-backspace': '0xf55a',
  'fa-backward': '0xf04a',
  'fa-bacon': '0xf7e5',
  'fa-bahai': '0xf666',
  'fa-balance-scale': '0xf24e',
  'fa-balance-scale-left': '0xf515',
  'fa-balance-scale-right': '0xf516',
  'fa-ban': '0xf05e',
  'fa-band-aid': '0xf462',
  'fa-bandcamp': '0xf2d5',
  'fa-barcode': '0xf02a',
  'fa-bars': '0xf0c9',
  'fa-baseball-ball': '0xf433',
  'fa-basketball-ball': '0xf434',
  'fa-bath': '0xf2cd',
  'fa-battery-empty': '0xf244',
  'fa-battery-full': '0xf240',
  'fa-battery-half': '0xf242',
  'fa-battery-quarter': '0xf243',
  'fa-battery-three-quarters': '0xf241',
  'fa-battle-net': '0xf835',
  'fa-bed': '0xf236',
  'fa-beer': '0xf0fc',
  'fa-behance': '0xf1b4',
  'fa-behance-square': '0xf1b5',
  'fa-bell': '0xf0f3',
  'fa-bell-slash': '0xf1f6',
  'fa-bezier-curve': '0xf55b',
  'fa-bible': '0xf647',
  'fa-bicycle': '0xf206',
  'fa-biking': '0xf84a',
  'fa-bimobject': '0xf378',
  'fa-binoculars': '0xf1e5',
  'fa-biohazard': '0xf780',
  'fa-birthday-cake': '0xf1fd',
  'fa-bitbucket': '0xf171',
  'fa-bitcoin': '0xf379',
  'fa-bity': '0xf37a',
  'fa-black-tie': '0xf27e',
  'fa-blackberry': '0xf37b',
  'fa-blender': '0xf517',
  'fa-blender-phone': '0xf6b6',
  'fa-blind': '0xf29d',
  'fa-blog': '0xf781',
  'fa-blogger': '0xf37c',
  'fa-blogger-b': '0xf37d',
  'fa-bluetooth': '0xf293',
  'fa-bluetooth-b': '0xf294',
  'fa-bold': '0xf032',
  'fa-bolt': '0xf0e7',
  'fa-bomb': '0xf1e2',
  'fa-bone': '0xf5d7',
  'fa-bong': '0xf55c',
  'fa-book': '0xf02d',
  'fa-book-dead': '0xf6b7',
  'fa-book-medical': '0xf7e6',
  'fa-book-open': '0xf518',
  'fa-book-reader': '0xf5da',
  'fa-bookmark': '0xf02e',
  'fa-bootstrap': '0xf836',
  'fa-border-all': '0xf84c',
  'fa-border-none': '0xf850',
  'fa-border-style': '0xf853',
  'fa-bowling-ball': '0xf436',
  'fa-box': '0xf466',
  'fa-box-open': '0xf49e',
  'fa-box-tissue': '0xf95b',
  'fa-boxes': '0xf468',
  'fa-braille': '0xf2a1',
  'fa-brain': '0xf5dc',
  'fa-bread-slice': '0xf7ec',
  'fa-briefcase': '0xf0b1',
  'fa-briefcase-medical': '0xf469',
  'fa-broadcast-tower': '0xf519',
  'fa-broom': '0xf51a',
  'fa-brush': '0xf55d',
  'fa-btc': '0xf15a',
  'fa-buffer': '0xf837',
  'fa-bug': '0xf188',
  'fa-building': '0xf1ad',
  'fa-bullhorn': '0xf0a1',
  'fa-bullseye': '0xf140',
  'fa-burn': '0xf46a',
  'fa-buromobelexperte': '0xf37f',
  'fa-bus': '0xf207',
  'fa-bus-alt': '0xf55e',
  'fa-business-time': '0xf64a',
  'fa-buy-n-large': '0xf8a6',
  'fa-buysellads': '0xf20d',
  'fa-calculator': '0xf1ec',
  'fa-calendar': '0xf133',
  'fa-calendar-alt': '0xf073',
  'fa-calendar-check': '0xf274',
  'fa-calendar-day': '0xf783',
  'fa-calendar-minus': '0xf272',
  'fa-calendar-plus': '0xf271',
  'fa-calendar-times': '0xf273',
  'fa-calendar-week': '0xf784',
  'fa-camera': '0xf030',
  'fa-camera-retro': '0xf083',
  'fa-campground': '0xf6bb',
  'fa-canadian-maple-leaf': '0xf785',
  'fa-candy-cane': '0xf786',
  'fa-cannabis': '0xf55f',
  'fa-capsules': '0xf46b',
  'fa-car': '0xf1b9',
  'fa-car-alt': '0xf5de',
  'fa-car-battery': '0xf5df',
  'fa-car-crash': '0xf5e1',
  'fa-car-side': '0xf5e4',
  'fa-caravan': '0xf8ff',
  'fa-caret-down': '0xf0d7',
  'fa-caret-left': '0xf0d9',
  'fa-caret-right': '0xf0da',
  'fa-caret-square-down': '0xf150',
  'fa-caret-square-left': '0xf191',
  'fa-caret-square-right': '0xf152',
  'fa-caret-square-up': '0xf151',
  'fa-caret-up': '0xf0d8',
  'fa-carrot': '0xf787',
  'fa-cart-arrow-down': '0xf218',
  'fa-cart-plus': '0xf217',
  'fa-cash-register': '0xf788',
  'fa-cat': '0xf6be',
  'fa-cc-amazon-pay': '0xf42d',
  'fa-cc-amex': '0xf1f3',
  'fa-cc-apple-pay': '0xf416',
  'fa-cc-diners-club': '0xf24c',
  'fa-cc-discover': '0xf1f2',
  'fa-cc-jcb': '0xf24b',
  'fa-cc-mastercard': '0xf1f1',
  'fa-cc-paypal': '0xf1f4',
  'fa-cc-stripe': '0xf1f5',
  'fa-cc-visa': '0xf1f0',
  'fa-centercode': '0xf380',
  'fa-centos': '0xf789',
  'fa-certificate': '0xf0a3',
  'fa-chair': '0xf6c0',
  'fa-chalkboard': '0xf51b',
  'fa-chalkboard-teacher': '0xf51c',
  'fa-charging-station': '0xf5e7',
  'fa-chart-area': '0xf1fe',
  'fa-chart-bar': '0xf080',
  'fa-chart-line': '0xf201',
  'fa-chart-pie': '0xf200',
  'fa-check': '0xf00c',
  'fa-check-circle': '0xf058',
  'fa-check-double': '0xf560',
  'fa-check-square': '0xf14a',
  'fa-cheese': '0xf7ef',
  'fa-chess': '0xf439',
  'fa-chess-bishop': '0xf43a',
  'fa-chess-board': '0xf43c',
  'fa-chess-king': '0xf43f',
  'fa-chess-knight': '0xf441',
  'fa-chess-pawn': '0xf443',
  'fa-chess-queen': '0xf445',
  'fa-chess-rook': '0xf447',
  'fa-chevron-circle-down': '0xf13a',
  'fa-chevron-circle-left': '0xf137',
  'fa-chevron-circle-right': '0xf138',
  'fa-chevron-circle-up': '0xf139',
  'fa-chevron-down': '0xf078',
  'fa-chevron-left': '0xf053',
  'fa-chevron-right': '0xf054',
  'fa-chevron-up': '0xf077',
  'fa-child': '0xf1ae',
  'fa-chrome': '0xf268',
  'fa-chromecast': '0xf838',
  'fa-church': '0xf51d',
  'fa-circle': '0xf111',
  'fa-circle-notch': '0xf1ce',
  'fa-city': '0xf64f',
  'fa-clinic-medical': '0xf7f2',
  'fa-clipboard': '0xf328',
  'fa-clipboard-check': '0xf46c',
  'fa-clipboard-list': '0xf46d',
  'fa-clock': '0xf017',
  'fa-clone': '0xf24d',
  'fa-closed-bodySmalling': '0xf20a',
  'fa-cloud': '0xf0c2',
  'fa-cloud-download-alt': '0xf381',
  'fa-cloud-meatball': '0xf73b',
  'fa-cloud-moon': '0xf6c3',
  'fa-cloud-moon-rain': '0xf73c',
  'fa-cloud-rain': '0xf73d',
  'fa-cloud-showers-heavy': '0xf740',
  'fa-cloud-sun': '0xf6c4',
  'fa-cloud-sun-rain': '0xf743',
  'fa-cloud-upload-alt': '0xf382',
  'fa-cloudscale': '0xf383',
  'fa-cloudsmith': '0xf384',
  'fa-cloudversify': '0xf385',
  'fa-cocktail': '0xf561',
  'fa-code': '0xf121',
  'fa-code-branch': '0xf126',
  'fa-codepen': '0xf1cb',
  'fa-codiepie': '0xf284',
  'fa-coffee': '0xf0f4',
  'fa-cog': '0xf013',
  'fa-cogs': '0xf085',
  'fa-coins': '0xf51e',
  'fa-columns': '0xf0db',
  'fa-comment': '0xf075',
  'fa-comment-alt': '0xf27a',
  'fa-comment-dollar': '0xf651',
  'fa-comment-dots': '0xf4ad',
  'fa-comment-medical': '0xf7f5',
  'fa-comment-slash': '0xf4b3',
  'fa-comments': '0xf086',
  'fa-comments-dollar': '0xf653',
  'fa-compact-disc': '0xf51f',
  'fa-compass': '0xf14e',
  'fa-compress': '0xf066',
  'fa-compress-alt': '0xf422',
  'fa-compress-arrows-alt': '0xf78c',
  'fa-concierge-bell': '0xf562',
  'fa-confluence': '0xf78d',
  'fa-connectdevelop': '0xf20e',
  'fa-contao': '0xf26d',
  'fa-cookie': '0xf563',
  'fa-cookie-bite': '0xf564',
  'fa-copy': '0xf0c5',
  'fa-copyright': '0xf1f9',
  'fa-cotton-bureau': '0xf89e',
  'fa-couch': '0xf4b8',
  'fa-cpanel': '0xf388',
  'fa-creative-commons': '0xf25e',
  'fa-creative-commons-by': '0xf4e7',
  'fa-creative-commons-nc': '0xf4e8',
  'fa-creative-commons-nc-eu': '0xf4e9',
  'fa-creative-commons-nc-jp': '0xf4ea',
  'fa-creative-commons-nd': '0xf4eb',
  'fa-creative-commons-pd': '0xf4ec',
  'fa-creative-commons-pd-alt': '0xf4ed',
  'fa-creative-commons-remix': '0xf4ee',
  'fa-creative-commons-sa': '0xf4ef',
  'fa-creative-commons-sampling': '0xf4f0',
  'fa-creative-commons-sampling-plus': '0xf4f1',
  'fa-creative-commons-share': '0xf4f2',
  'fa-creative-commons-zero': '0xf4f3',
  'fa-credit-card': '0xf09d',
  'fa-critical-role': '0xf6c9',
  'fa-crop': '0xf125',
  'fa-crop-alt': '0xf565',
  'fa-cross': '0xf654',
  'fa-crosshairs': '0xf05b',
  'fa-crow': '0xf520',
  'fa-crown': '0xf521',
  'fa-crutch': '0xf7f7',
  'fa-css3': '0xf13c',
  'fa-css3-alt': '0xf38b',
  'fa-cube': '0xf1b2',
  'fa-cubes': '0xf1b3',
  'fa-cut': '0xf0c4',
  'fa-cuttlefish': '0xf38c',
  'fa-d-and-d': '0xf38d',
  'fa-d-and-d-beyond': '0xf6ca',
  'fa-dailymotion': '0xf952',
  'fa-dashcube': '0xf210',
  'fa-database': '0xf1c0',
  'fa-deaf': '0xf2a4',
  'fa-delicious': '0xf1a5',
  'fa-democrat': '0xf747',
  'fa-deploydog': '0xf38e',
  'fa-deskpro': '0xf38f',
  'fa-desktop': '0xf108',
  'fa-dev': '0xf6cc',
  'fa-deviantart': '0xf1bd',
  'fa-dharmachakra': '0xf655',
  'fa-dhl': '0xf790',
  'fa-diagnoses': '0xf470',
  'fa-diaspora': '0xf791',
  'fa-dice': '0xf522',
  'fa-dice-d20': '0xf6cf',
  'fa-dice-d6': '0xf6d1',
  'fa-dice-five': '0xf523',
  'fa-dice-four': '0xf524',
  'fa-dice-one': '0xf525',
  'fa-dice-six': '0xf526',
  'fa-dice-three': '0xf527',
  'fa-dice-two': '0xf528',
  'fa-digg': '0xf1a6',
  'fa-digital-ocean': '0xf391',
  'fa-digital-tachograph': '0xf566',
  'fa-directions': '0xf5eb',
  'fa-discord': '0xf392',
  'fa-discourse': '0xf393',
  'fa-disease': '0xf7fa',
  'fa-divide': '0xf529',
  'fa-dizzy': '0xf567',
  'fa-dna': '0xf471',
  'fa-dochub': '0xf394',
  'fa-docker': '0xf395',
  'fa-dog': '0xf6d3',
  'fa-dollar-sign': '0xf155',
  'fa-dolly': '0xf472',
  'fa-dolly-flatbed': '0xf474',
  'fa-donate': '0xf4b9',
  'fa-door-closed': '0xf52a',
  'fa-door-open': '0xf52b',
  'fa-dot-circle': '0xf192',
  'fa-dove': '0xf4ba',
  'fa-download': '0xf019',
  'fa-draft2digital': '0xf396',
  'fa-drafting-compass': '0xf568',
  'fa-dragon': '0xf6d5',
  'fa-draw-polygon': '0xf5ee',
  'fa-dribbble': '0xf17d',
  'fa-dribbble-square': '0xf397',
  'fa-dropbox': '0xf16b',
  'fa-drum': '0xf569',
  'fa-drum-steelpan': '0xf56a',
  'fa-drumstick-bite': '0xf6d7',
  'fa-drupal': '0xf1a9',
  'fa-dumbbell': '0xf44b',
  'fa-dumpster': '0xf793',
  'fa-dumpster-fire': '0xf794',
  'fa-dungeon': '0xf6d9',
  'fa-dyalog': '0xf399',
  'fa-earlybirds': '0xf39a',
  'fa-ebay': '0xf4f4',
  'fa-edge': '0xf282',
  'fa-edit': '0xf044',
  'fa-egg': '0xf7fb',
  'fa-eject': '0xf052',
  'fa-elementor': '0xf430',
  'fa-ellipsis-h': '0xf141',
  'fa-ellipsis-v': '0xf142',
  'fa-ello': '0xf5f1',
  'fa-ember': '0xf423',
  'fa-empire': '0xf1d1',
  'fa-envelope': '0xf0e0',
  'fa-envelope-open': '0xf2b6',
  'fa-envelope-open-text': '0xf658',
  'fa-envelope-square': '0xf199',
  'fa-envira': '0xf299',
  'fa-equals': '0xf52c',
  'fa-eraser': '0xf12d',
  'fa-erlang': '0xf39d',
  'fa-ethereum': '0xf42e',
  'fa-ethernet': '0xf796',
  'fa-etsy': '0xf2d7',
  'fa-euro-sign': '0xf153',
  'fa-evernote': '0xf839',
  'fa-exchange-alt': '0xf362',
  'fa-exclamation': '0xf12a',
  'fa-exclamation-circle': '0xf06a',
  'fa-exclamation-triangle': '0xf071',
  'fa-expand': '0xf065',
  'fa-expand-alt': '0xf424',
  'fa-expand-arrows-alt': '0xf31e',
  'fa-expeditedssl': '0xf23e',
  'fa-external-link-alt': '0xf35d',
  'fa-external-link-square-alt': '0xf360',
  'fa-eye': '0xf06e',
  'fa-eye-dropper': '0xf1fb',
  'fa-eye-slash': '0xf070',
  'fa-facebook': '0xf09a',
  'fa-facebook-f': '0xf39e',
  'fa-facebook-messenger': '0xf39f',
  'fa-facebook-square': '0xf082',
  'fa-fan': '0xf863',
  'fa-fantasy-flight-games': '0xf6dc',
  'fa-fast-backward': '0xf049',
  'fa-fast-forward': '0xf050',
  'fa-faucet': '0xf905',
  'fa-fax': '0xf1ac',
  'fa-feather': '0xf52d',
  'fa-feather-alt': '0xf56b',
  'fa-fedex': '0xf797',
  'fa-fedora': '0xf798',
  'fa-female': '0xf182',
  'fa-fighter-jet': '0xf0fb',
  'fa-figma': '0xf799',
  'fa-file': '0xf15b',
  'fa-file-alt': '0xf15c',
  'fa-file-archive': '0xf1c6',
  'fa-file-audio': '0xf1c7',
  'fa-file-code': '0xf1c9',
  'fa-file-contract': '0xf56c',
  'fa-file-csv': '0xf6dd',
  'fa-file-download': '0xf56d',
  'fa-file-excel': '0xf1c3',
  'fa-file-export': '0xf56e',
  'fa-file-image': '0xf1c5',
  'fa-file-import': '0xf56f',
  'fa-file-invoice': '0xf570',
  'fa-file-invoice-dollar': '0xf571',
  'fa-file-medical': '0xf477',
  'fa-file-medical-alt': '0xf478',
  'fa-file-pdf': '0xf1c1',
  'fa-file-powerpoint': '0xf1c4',
  'fa-file-prescription': '0xf572',
  'fa-file-signature': '0xf573',
  'fa-file-upload': '0xf574',
  'fa-file-video': '0xf1c8',
  'fa-file-word': '0xf1c2',
  'fa-fill': '0xf575',
  'fa-fill-drip': '0xf576',
  'fa-film': '0xf008',
  'fa-filter': '0xf0b0',
  'fa-fingerprint': '0xf577',
  'fa-fire': '0xf06d',
  'fa-fire-alt': '0xf7e4',
  'fa-fire-extinguisher': '0xf134',
  'fa-firefox': '0xf269',
  'fa-firefox-browser': '0xf907',
  'fa-first-aid': '0xf479',
  'fa-first-order': '0xf2b0',
  'fa-first-order-alt': '0xf50a',
  'fa-firstdraft': '0xf3a1',
  'fa-fish': '0xf578',
  'fa-fist-raised': '0xf6de',
  'fa-flag': '0xf024',
  'fa-flag-checkered': '0xf11e',
  'fa-flag-usa': '0xf74d',
  'fa-flask': '0xf0c3',
  'fa-flickr': '0xf16e',
  'fa-flipboard': '0xf44d',
  'fa-flushed': '0xf579',
  'fa-fly': '0xf417',
  'fa-folder': '0xf07b',
  'fa-folder-minus': '0xf65d',
  'fa-folder-open': '0xf07c',
  'fa-folder-plus': '0xf65e',
  'fa-font': '0xf031',
  'fa-font-awesome': '0xf2b4',
  'fa-font-awesome-alt': '0xf35c',
  'fa-font-awesome-flag': '0xf425',
  'fa-font-awesome-logo-full': '0xf4e6',
  'fa-fonticons': '0xf280',
  'fa-fonticons-fi': '0xf3a2',
  'fa-football-ball': '0xf44e',
  'fa-fort-awesome': '0xf286',
  'fa-fort-awesome-alt': '0xf3a3',
  'fa-forumbee': '0xf211',
  'fa-forward': '0xf04e',
  'fa-foursquare': '0xf180',
  'fa-free-code-camp': '0xf2c5',
  'fa-freebsd': '0xf3a4',
  'fa-frog': '0xf52e',
  'fa-frown': '0xf119',
  'fa-frown-open': '0xf57a',
  'fa-fulcrum': '0xf50b',
  'fa-funnel-dollar': '0xf662',
  'fa-futbol': '0xf1e3',
  'fa-galactic-republic': '0xf50c',
  'fa-galactic-senate': '0xf50d',
  'fa-gamepad': '0xf11b',
  'fa-gas-pump': '0xf52f',
  'fa-gavel': '0xf0e3',
  'fa-gem': '0xf3a5',
  'fa-genderless': '0xf22d',
  'fa-get-pocket': '0xf265',
  'fa-gg': '0xf260',
  'fa-gg-circle': '0xf261',
  'fa-ghost': '0xf6e2',
  'fa-gift': '0xf06b',
  'fa-gifts': '0xf79c',
  'fa-git': '0xf1d3',
  'fa-git-alt': '0xf841',
  'fa-git-square': '0xf1d2',
  'fa-github': '0xf09b',
  'fa-github-alt': '0xf113',
  'fa-github-square': '0xf092',
  'fa-gitkraken': '0xf3a6',
  'fa-gitlab': '0xf296',
  'fa-gitter': '0xf426',
  'fa-glass-cheers': '0xf79f',
  'fa-glass-martini': '0xf000',
  'fa-glass-martini-alt': '0xf57b',
  'fa-glass-whiskey': '0xf7a0',
  'fa-glasses': '0xf530',
  'fa-glide': '0xf2a5',
  'fa-glide-g': '0xf2a6',
  'fa-globe': '0xf0ac',
  'fa-globe-africa': '0xf57c',
  'fa-globe-americas': '0xf57d',
  'fa-globe-asia': '0xf57e',
  'fa-globe-europe': '0xf7a2',
  'fa-gofore': '0xf3a7',
  'fa-golf-ball': '0xf450',
  'fa-goodreads': '0xf3a8',
  'fa-goodreads-g': '0xf3a9',
  'fa-google': '0xf1a0',
  'fa-google-drive': '0xf3aa',
  'fa-google-play': '0xf3ab',
  'fa-google-plus': '0xf2b3',
  'fa-google-plus-g': '0xf0d5',
  'fa-google-plus-square': '0xf0d4',
  'fa-google-wallet': '0xf1ee',
  'fa-gopuram': '0xf664',
  'fa-graduation-cap': '0xf19d',
  'fa-gratipay': '0xf184',
  'fa-grav': '0xf2d6',
  'fa-greater-than': '0xf531',
  'fa-greater-than-equal': '0xf532',
  'fa-grimace': '0xf57f',
  'fa-grin': '0xf580',
  'fa-grin-alt': '0xf581',
  'fa-grin-beam': '0xf582',
  'fa-grin-beam-sweat': '0xf583',
  'fa-grin-hearts': '0xf584',
  'fa-grin-squint': '0xf585',
  'fa-grin-squint-tears': '0xf586',
  'fa-grin-stars': '0xf587',
  'fa-grin-tears': '0xf588',
  'fa-grin-tongue': '0xf589',
  'fa-grin-tongue-squint': '0xf58a',
  'fa-grin-tongue-wink': '0xf58b',
  'fa-grin-wink': '0xf58c',
  'fa-grip-horizontal': '0xf58d',
  'fa-grip-lines': '0xf7a4',
  'fa-grip-lines-vertical': '0xf7a5',
  'fa-grip-vertical': '0xf58e',
  'fa-gripfire': '0xf3ac',
  'fa-grunt': '0xf3ad',
  'fa-guitar': '0xf7a6',
  'fa-gulp': '0xf3ae',
  'fa-h-square': '0xf0fd',
  'fa-hacker-news': '0xf1d4',
  'fa-hacker-news-square': '0xf3af',
  'fa-hackerrank': '0xf5f7',
  'fa-hamburger': '0xf805',
  'fa-hammer': '0xf6e3',
  'fa-hamsa': '0xf665',
  'fa-hand-holding': '0xf4bd',
  'fa-hand-holding-heart': '0xf4be',
  'fa-hand-holding-medical': '0xf95c',
  'fa-hand-holding-usd': '0xf4c0',
  'fa-hand-holding-water': '0xf4c1',
  'fa-hand-lizard': '0xf258',
  'fa-hand-middle-finger': '0xf806',
  'fa-hand-paper': '0xf256',
  'fa-hand-peace': '0xf25b',
  'fa-hand-point-down': '0xf0a7',
  'fa-hand-point-left': '0xf0a5',
  'fa-hand-point-right': '0xf0a4',
  'fa-hand-point-up': '0xf0a6',
  'fa-hand-pointer': '0xf25a',
  'fa-hand-rock': '0xf255',
  'fa-hand-scissors': '0xf257',
  'fa-hand-sparkles': '0xf95d',
  'fa-hand-spock': '0xf259',
  'fa-hands': '0xf4c2',
  'fa-hands-helping': '0xf4c4',
  'fa-hands-wash': '0xf95e',
  'fa-handshake': '0xf2b5',
  'fa-handshake-alt-slash': '0xf95f',
  'fa-handshake-slash': '0xf960',
  'fa-hanukiah': '0xf6e6',
  'fa-hard-hat': '0xf807',
  'fa-hashtag': '0xf292',
  'fa-hat-cowboy': '0xf8c0',
  'fa-hat-cowboy-side': '0xf8c1',
  'fa-hat-wizard': '0xf6e8',
  'fa-hdd': '0xf0a0',
  'fa-head-side-cough': '0xf961',
  'fa-head-side-cough-slash': '0xf962',
  'fa-head-side-mask': '0xf963',
  'fa-head-side-virus': '0xf964',
  'fa-heading': '0xf1dc',
  'fa-headphones': '0xf025',
  'fa-headphones-alt': '0xf58f',
  'fa-headset': '0xf590',
  'fa-heart': '0xf004',
  'fa-heart-broken': '0xf7a9',
  'fa-heartbeat': '0xf21e',
  'fa-helicopter': '0xf533',
  'fa-highlighter': '0xf591',
  'fa-hiking': '0xf6ec',
  'fa-hippo': '0xf6ed',
  'fa-hips': '0xf452',
  'fa-hire-a-helper': '0xf3b0',
  'fa-history': '0xf1da',
  'fa-hockey-puck': '0xf453',
  'fa-holly-berry': '0xf7aa',
  'fa-home': '0xf015',
  'fa-hooli': '0xf427',
  'fa-hornbill': '0xf592',
  'fa-horse': '0xf6f0',
  'fa-horse-head': '0xf7ab',
  'fa-hospital': '0xf0f8',
  'fa-hospital-alt': '0xf47d',
  'fa-hospital-symbol': '0xf47e',
  'fa-hospital-user': '0xf80d',
  'fa-hot-tub': '0xf593',
  'fa-hotdog': '0xf80f',
  'fa-hotel': '0xf594',
  'fa-hotjar': '0xf3b1',
  'fa-hourglass': '0xf254',
  'fa-hourglass-end': '0xf253',
  'fa-hourglass-half': '0xf252',
  'fa-hourglass-start': '0xf251',
  'fa-house-damage': '0xf6f1',
  'fa-house-user': '0xf965',
  'fa-houzz': '0xf27c',
  'fa-hryvnia': '0xf6f2',
  'fa-html5': '0xf13b',
  'fa-hubspot': '0xf3b2',
  'fa-i-cursor': '0xf246',
  'fa-ice-cream': '0xf810',
  'fa-icicles': '0xf7ad',
  'fa-icons': '0xf86d',
  'fa-id-badge': '0xf2c1',
  'fa-id-card': '0xf2c2',
  'fa-id-card-alt': '0xf47f',
  'fa-ideal': '0xf913',
  'fa-igloo': '0xf7ae',
  'fa-image': '0xf03e',
  'fa-images': '0xf302',
  'fa-imdb': '0xf2d8',
  'fa-inbox': '0xf01c',
  'fa-indent': '0xf03c',
  'fa-industry': '0xf275',
  'fa-infinity': '0xf534',
  'fa-info': '0xf129',
  'fa-info-circle': '0xf05a',
  'fa-instagram': '0xf16d',
  'fa-instagram-square': '0xf955',
  'fa-intercom': '0xf7af',
  'fa-internet-explorer': '0xf26b',
  'fa-invision': '0xf7b0',
  'fa-ioxhost': '0xf208',
  'fa-italic': '0xf033',
  'fa-itch-io': '0xf83a',
  'fa-itunes': '0xf3b4',
  'fa-itunes-note': '0xf3b5',
  'fa-java': '0xf4e4',
  'fa-jedi': '0xf669',
  'fa-jedi-order': '0xf50e',
  'fa-jenkins': '0xf3b6',
  'fa-jira': '0xf7b1',
  'fa-joget': '0xf3b7',
  'fa-joint': '0xf595',
  'fa-joomla': '0xf1aa',
  'fa-journal-whills': '0xf66a',
  'fa-js': '0xf3b8',
  'fa-js-square': '0xf3b9',
  'fa-jsfiddle': '0xf1cc',
  'fa-kaaba': '0xf66b',
  'fa-kaggle': '0xf5fa',
  'fa-key': '0xf084',
  'fa-keybase': '0xf4f5',
  'fa-keyboard': '0xf11c',
  'fa-keycdn': '0xf3ba',
  'fa-khanda': '0xf66d',
  'fa-kickstarter': '0xf3bb',
  'fa-kickstarter-k': '0xf3bc',
  'fa-kiss': '0xf596',
  'fa-kiss-beam': '0xf597',
  'fa-kiss-wink-heart': '0xf598',
  'fa-kiwi-bird': '0xf535',
  'fa-korvue': '0xf42f',
  'fa-landmark': '0xf66f',
  'fa-language': '0xf1ab',
  'fa-laptop': '0xf109',
  'fa-laptop-code': '0xf5fc',
  'fa-laptop-house': '0xf966',
  'fa-laptop-medical': '0xf812',
  'fa-laravel': '0xf3bd',
  'fa-lastfm': '0xf202',
  'fa-lastfm-square': '0xf203',
  'fa-laugh': '0xf599',
  'fa-laugh-beam': '0xf59a',
  'fa-laugh-squint': '0xf59b',
  'fa-laugh-wink': '0xf59c',
  'fa-layer-group': '0xf5fd',
  'fa-leaf': '0xf06c',
  'fa-leanpub': '0xf212',
  'fa-lemon': '0xf094',
  'fa-less': '0xf41d',
  'fa-less-than': '0xf536',
  'fa-less-than-equal': '0xf537',
  'fa-level-down-alt': '0xf3be',
  'fa-level-up-alt': '0xf3bf',
  'fa-life-ring': '0xf1cd',
  'fa-lightbulb': '0xf0eb',
  'fa-line': '0xf3c0',
  'fa-link': '0xf0c1',
  'fa-linkedin': '0xf08c',
  'fa-linkedin-in': '0xf0e1',
  'fa-linode': '0xf2b8',
  'fa-linux': '0xf17c',
  'fa-lira-sign': '0xf195',
  'fa-list': '0xf03a',
  'fa-list-alt': '0xf022',
  'fa-list-ol': '0xf0cb',
  'fa-list-ul': '0xf0ca',
  'fa-location-arrow': '0xf124',
  'fa-lock': '0xf023',
  'fa-lock-open': '0xf3c1',
  'fa-long-arrow-alt-down': '0xf309',
  'fa-long-arrow-alt-left': '0xf30a',
  'fa-long-arrow-alt-right': '0xf30b',
  'fa-long-arrow-alt-up': '0xf30c',
  'fa-low-vision': '0xf2a8',
  'fa-luggage-cart': '0xf59d',
  'fa-lungs': '0xf604',
  'fa-lungs-virus': '0xf967',
  'fa-lyft': '0xf3c3',
  'fa-magento': '0xf3c4',
  'fa-magic': '0xf0d0',
  'fa-magnet': '0xf076',
  'fa-mail-bulk': '0xf674',
  'fa-mailchimp': '0xf59e',
  'fa-male': '0xf183',
  'fa-mandalorian': '0xf50f',
  'fa-map': '0xf279',
  'fa-map-marked': '0xf59f',
  'fa-map-marked-alt': '0xf5a0',
  'fa-map-marker': '0xf041',
  'fa-map-marker-alt': '0xf3c5',
  'fa-map-pin': '0xf276',
  'fa-map-signs': '0xf277',
  'fa-markdown': '0xf60f',
  'fa-marker': '0xf5a1',
  'fa-mars': '0xf222',
  'fa-mars-double': '0xf227',
  'fa-mars-stroke': '0xf229',
  'fa-mars-stroke-h': '0xf22b',
  'fa-mars-stroke-v': '0xf22a',
  'fa-mask': '0xf6fa',
  'fa-mastodon': '0xf4f6',
  'fa-maxcdn': '0xf136',
  'fa-mdb': '0xf8ca',
  'fa-medal': '0xf5a2',
  'fa-medapps': '0xf3c6',
  'fa-medium': '0xf23a',
  'fa-medium-m': '0xf3c7',
  'fa-medkit': '0xf0fa',
  'fa-medrt': '0xf3c8',
  'fa-meetup': '0xf2e0',
  'fa-megaport': '0xf5a3',
  'fa-meh': '0xf11a',
  'fa-meh-blank': '0xf5a4',
  'fa-meh-rolling-eyes': '0xf5a5',
  'fa-memory': '0xf538',
  'fa-mendeley': '0xf7b3',
  'fa-menorah': '0xf676',
  'fa-mercury': '0xf223',
  'fa-meteor': '0xf753',
  'fa-microblog': '0xf91a',
  'fa-microchip': '0xf2db',
  'fa-microphone': '0xf130',
  'fa-microphone-alt': '0xf3c9',
  'fa-microphone-alt-slash': '0xf539',
  'fa-microphone-slash': '0xf131',
  'fa-microscope': '0xf610',
  'fa-microsoft': '0xf3ca',
  'fa-minus': '0xf068',
  'fa-minus-circle': '0xf056',
  'fa-minus-square': '0xf146',
  'fa-mitten': '0xf7b5',
  'fa-mix': '0xf3cb',
  'fa-mixcloud': '0xf289',
  'fa-mixer': '0xf956',
  'fa-mizuni': '0xf3cc',
  'fa-mobile': '0xf10b',
  'fa-mobile-alt': '0xf3cd',
  'fa-modx': '0xf285',
  'fa-monero': '0xf3d0',
  'fa-money-bill': '0xf0d6',
  'fa-money-bill-alt': '0xf3d1',
  'fa-money-bill-wave': '0xf53a',
  'fa-money-bill-wave-alt': '0xf53b',
  'fa-money-check': '0xf53c',
  'fa-money-check-alt': '0xf53d',
  'fa-monument': '0xf5a6',
  'fa-moon': '0xf186',
  'fa-mortar-pestle': '0xf5a7',
  'fa-mosque': '0xf678',
  'fa-motorcycle': '0xf21c',
  'fa-mountain': '0xf6fc',
  'fa-mouse': '0xf8cc',
  'fa-mouse-pointer': '0xf245',
  'fa-mug-hot': '0xf7b6',
  'fa-music': '0xf001',
  'fa-napster': '0xf3d2',
  'fa-neos': '0xf612',
  'fa-network-wired': '0xf6ff',
  'fa-neuter': '0xf22c',
  'fa-newspaper': '0xf1ea',
  'fa-nimblr': '0xf5a8',
  'fa-node': '0xf419',
  'fa-node-js': '0xf3d3',
  'fa-not-equal': '0xf53e',
  'fa-notes-medical': '0xf481',
  'fa-npm': '0xf3d4',
  'fa-ns8': '0xf3d5',
  'fa-nutritionix': '0xf3d6',
  'fa-object-group': '0xf247',
  'fa-object-ungroup': '0xf248',
  'fa-odnoklassniki': '0xf263',
  'fa-odnoklassniki-square': '0xf264',
  'fa-oil-can': '0xf613',
  'fa-old-republic': '0xf510',
  'fa-om': '0xf679',
  'fa-opencart': '0xf23d',
  'fa-openid': '0xf19b',
  'fa-opera': '0xf26a',
  'fa-optin-monster': '0xf23c',
  'fa-orcid': '0xf8d2',
  'fa-osi': '0xf41a',
  'fa-otter': '0xf700',
  'fa-outdent': '0xf03b',
  'fa-page4': '0xf3d7',
  'fa-pagelines': '0xf18c',
  'fa-pager': '0xf815',
  'fa-paint-brush': '0xf1fc',
  'fa-paint-roller': '0xf5aa',
  'fa-palette': '0xf53f',
  'fa-palfed': '0xf3d8',
  'fa-pallet': '0xf482',
  'fa-paper-plane': '0xf1d8',
  'fa-paperclip': '0xf0c6',
  'fa-parachute-box': '0xf4cd',
  'fa-paragraph': '0xf1dd',
  'fa-parking': '0xf540',
  'fa-passport': '0xf5ab',
  'fa-pastafarianism': '0xf67b',
  'fa-paste': '0xf0ea',
  'fa-patreon': '0xf3d9',
  'fa-pause': '0xf04c',
  'fa-pause-circle': '0xf28b',
  'fa-paw': '0xf1b0',
  'fa-paypal': '0xf1ed',
  'fa-peace': '0xf67c',
  'fa-pen': '0xf304',
  'fa-pen-alt': '0xf305',
  'fa-pen-fancy': '0xf5ac',
  'fa-pen-nib': '0xf5ad',
  'fa-pen-square': '0xf14b',
  'fa-pencil-alt': '0xf303',
  'fa-pencil-ruler': '0xf5ae',
  'fa-penny-arcade': '0xf704',
  'fa-people-arrows': '0xf968',
  'fa-people-carry': '0xf4ce',
  'fa-pepper-hot': '0xf816',
  'fa-percent': '0xf295',
  'fa-percentage': '0xf541',
  'fa-periscope': '0xf3da',
  'fa-person-booth': '0xf756',
  'fa-phabricator': '0xf3db',
  'fa-phoenix-framework': '0xf3dc',
  'fa-phoenix-squadron': '0xf511',
  'fa-phone': '0xf095',
  'fa-phone-alt': '0xf879',
  'fa-phone-slash': '0xf3dd',
  'fa-phone-square': '0xf098',
  'fa-phone-square-alt': '0xf87b',
  'fa-phone-volume': '0xf2a0',
  'fa-photo-video': '0xf87c',
  'fa-php': '0xf457',
  'fa-pied-piper': '0xf2ae',
  'fa-pied-piper-alt': '0xf1a8',
  'fa-pied-piper-hat': '0xf4e5',
  'fa-pied-piper-pp': '0xf1a7',
  'fa-pied-piper-square': '0xf91e',
  'fa-piggy-bank': '0xf4d3',
  'fa-pills': '0xf484',
  'fa-pinterest': '0xf0d2',
  'fa-pinterest-p': '0xf231',
  'fa-pinterest-square': '0xf0d3',
  'fa-pizza-slice': '0xf818',
  'fa-place-of-worship': '0xf67f',
  'fa-plane': '0xf072',
  'fa-plane-arrival': '0xf5af',
  'fa-plane-departure': '0xf5b0',
  'fa-plane-slash': '0xf969',
  'fa-play': '0xf04b',
  'fa-play-circle': '0xf144',
  'fa-playstation': '0xf3df',
  'fa-plug': '0xf1e6',
  'fa-plus': '0xf067',
  'fa-plus-circle': '0xf055',
  'fa-plus-square': '0xf0fe',
  'fa-podcast': '0xf2ce',
  'fa-poll': '0xf681',
  'fa-poll-h': '0xf682',
  'fa-poo': '0xf2fe',
  'fa-poo-storm': '0xf75a',
  'fa-poop': '0xf619',
  'fa-portrait': '0xf3e0',
  'fa-pound-sign': '0xf154',
  'fa-power-off': '0xf011',
  'fa-pray': '0xf683',
  'fa-praying-hands': '0xf684',
  'fa-prescription': '0xf5b1',
  'fa-prescription-bottle': '0xf485',
  'fa-prescription-bottle-alt': '0xf486',
  'fa-print': '0xf02f',
  'fa-procedures': '0xf487',
  'fa-product-hunt': '0xf288',
  'fa-project-diagram': '0xf542',
  'fa-pump-medical': '0xf96a',
  'fa-pump-soap': '0xf96b',
  'fa-pushed': '0xf3e1',
  'fa-puzzle-piece': '0xf12e',
  'fa-python': '0xf3e2',
  'fa-qq': '0xf1d6',
  'fa-qrcode': '0xf029',
  'fa-question': '0xf128',
  'fa-question-circle': '0xf059',
  'fa-quidditch': '0xf458',
  'fa-quinscape': '0xf459',
  'fa-quora': '0xf2c4',
  'fa-quote-left': '0xf10d',
  'fa-quote-right': '0xf10e',
  'fa-quran': '0xf687',
  'fa-r-project': '0xf4f7',
  'fa-radiation': '0xf7b9',
  'fa-radiation-alt': '0xf7ba',
  'fa-rainbow': '0xf75b',
  'fa-random': '0xf074',
  'fa-raspberry-pi': '0xf7bb',
  'fa-ravelry': '0xf2d9',
  'fa-react': '0xf41b',
  'fa-reacteurope': '0xf75d',
  'fa-readme': '0xf4d5',
  'fa-rebel': '0xf1d0',
  'fa-receipt': '0xf543',
  'fa-record-vinyl': '0xf8d9',
  'fa-recycle': '0xf1b8',
  'fa-red-river': '0xf3e3',
  'fa-reddit': '0xf1a1',
  'fa-reddit-alien': '0xf281',
  'fa-reddit-square': '0xf1a2',
  'fa-redhat': '0xf7bc',
  'fa-redo': '0xf01e',
  'fa-redo-alt': '0xf2f9',
  'fa-registered': '0xf25d',
  'fa-remove-format': '0xf87d',
  'fa-renren': '0xf18b',
  'fa-reply': '0xf3e5',
  'fa-reply-all': '0xf122',
  'fa-replyd': '0xf3e6',
  'fa-republican': '0xf75e',
  'fa-researchgate': '0xf4f8',
  'fa-resolving': '0xf3e7',
  'fa-restroom': '0xf7bd',
  'fa-retweet': '0xf079',
  'fa-rev': '0xf5b2',
  'fa-ribbon': '0xf4d6',
  'fa-ring': '0xf70b',
  'fa-road': '0xf018',
  'fa-robot': '0xf544',
  'fa-rocket': '0xf135',
  'fa-rocketchat': '0xf3e8',
  'fa-rockrms': '0xf3e9',
  'fa-route': '0xf4d7',
  'fa-rss': '0xf09e',
  'fa-rss-square': '0xf143',
  'fa-ruble-sign': '0xf158',
  'fa-ruler': '0xf545',
  'fa-ruler-combined': '0xf546',
  'fa-ruler-horizontal': '0xf547',
  'fa-ruler-vertical': '0xf548',
  'fa-running': '0xf70c',
  'fa-rupee-sign': '0xf156',
  'fa-sad-cry': '0xf5b3',
  'fa-sad-tear': '0xf5b4',
  'fa-safari': '0xf267',
  'fa-salesforce': '0xf83b',
  'fa-sass': '0xf41e',
  'fa-satellite': '0xf7bf',
  'fa-satellite-dish': '0xf7c0',
  'fa-save': '0xf0c7',
  'fa-schlix': '0xf3ea',
  'fa-school': '0xf549',
  'fa-screwdriver': '0xf54a',
  'fa-scribd': '0xf28a',
  'fa-scroll': '0xf70e',
  'fa-sd-card': '0xf7c2',
  'fa-search': '0xf002',
  'fa-search-dollar': '0xf688',
  'fa-search-location': '0xf689',
  'fa-search-minus': '0xf010',
  'fa-search-plus': '0xf00e',
  'fa-searchengin': '0xf3eb',
  'fa-seedling': '0xf4d8',
  'fa-sellcast': '0xf2da',
  'fa-sellsy': '0xf213',
  'fa-server': '0xf233',
  'fa-servicestack': '0xf3ec',
  'fa-shapes': '0xf61f',
  'fa-share': '0xf064',
  'fa-share-alt': '0xf1e0',
  'fa-share-alt-square': '0xf1e1',
  'fa-share-square': '0xf14d',
  'fa-shekel-sign': '0xf20b',
  'fa-shield-alt': '0xf3ed',
  'fa-shield-virus': '0xf96c',
  'fa-ship': '0xf21a',
  'fa-shipping-fast': '0xf48b',
  'fa-shirtsinbulk': '0xf214',
  'fa-shoe-prints': '0xf54b',
  'fa-shopify': '0xf957',
  'fa-shopping-bag': '0xf290',
  'fa-shopping-basket': '0xf291',
  'fa-shopping-cart': '0xf07a',
  'fa-shopware': '0xf5b5',
  'fa-shower': '0xf2cc',
  'fa-shuttle-van': '0xf5b6',
  'fa-sign': '0xf4d9',
  'fa-sign-in-alt': '0xf2f6',
  'fa-sign-language': '0xf2a7',
  'fa-sign-out-alt': '0xf2f5',
  'fa-signal': '0xf012',
  'fa-signature': '0xf5b7',
  'fa-sim-card': '0xf7c4',
  'fa-simplybuilt': '0xf215',
  'fa-sistrix': '0xf3ee',
  'fa-sitemap': '0xf0e8',
  'fa-sith': '0xf512',
  'fa-skating': '0xf7c5',
  'fa-sketch': '0xf7c6',
  'fa-skiing': '0xf7c9',
  'fa-skiing-nordic': '0xf7ca',
  'fa-skull': '0xf54c',
  'fa-skull-crossbones': '0xf714',
  'fa-skyatlas': '0xf216',
  'fa-skype': '0xf17e',
  'fa-slack': '0xf198',
  'fa-slack-hash': '0xf3ef',
  'fa-slash': '0xf715',
  'fa-sleigh': '0xf7cc',
  'fa-sliders-h': '0xf1de',
  'fa-slideshare': '0xf1e7',
  'fa-smile': '0xf118',
  'fa-smile-beam': '0xf5b8',
  'fa-smile-wink': '0xf4da',
  'fa-smog': '0xf75f',
  'fa-smoking': '0xf48d',
  'fa-smoking-ban': '0xf54d',
  'fa-sms': '0xf7cd',
  'fa-snapchat': '0xf2ab',
  'fa-snapchat-ghost': '0xf2ac',
  'fa-snapchat-square': '0xf2ad',
  'fa-snowboarding': '0xf7ce',
  'fa-snowflake': '0xf2dc',
  'fa-snowman': '0xf7d0',
  'fa-snowplow': '0xf7d2',
  'fa-soap': '0xf96e',
  'fa-socks': '0xf696',
  'fa-solar-panel': '0xf5ba',
  'fa-sort': '0xf0dc',
  'fa-sort-alpha-down': '0xf15d',
  'fa-sort-alpha-down-alt': '0xf881',
  'fa-sort-alpha-up': '0xf15e',
  'fa-sort-alpha-up-alt': '0xf882',
  'fa-sort-amount-down': '0xf160',
  'fa-sort-amount-down-alt': '0xf884',
  'fa-sort-amount-up': '0xf161',
  'fa-sort-amount-up-alt': '0xf885',
  'fa-sort-down': '0xf0dd',
  'fa-sort-numeric-down': '0xf162',
  'fa-sort-numeric-down-alt': '0xf886',
  'fa-sort-numeric-up': '0xf163',
  'fa-sort-numeric-up-alt': '0xf887',
  'fa-sort-up': '0xf0de',
  'fa-soundcloud': '0xf1be',
  'fa-sourcetree': '0xf7d3',
  'fa-spa': '0xf5bb',
  'fa-space-shuttle': '0xf197',
  'fa-speakap': '0xf3f3',
  'fa-speaker-deck': '0xf83c',
  'fa-spell-check': '0xf891',
  'fa-spider': '0xf717',
  'fa-spinner': '0xf110',
  'fa-splotch': '0xf5bc',
  'fa-spotify': '0xf1bc',
  'fa-spray-can': '0xf5bd',
  'fa-square': '0xf0c8',
  'fa-square-full': '0xf45c',
  'fa-square-root-alt': '0xf698',
  'fa-squarespace': '0xf5be',
  'fa-stack-exchange': '0xf18d',
  'fa-stack-overflow': '0xf16c',
  'fa-stackpath': '0xf842',
  'fa-stamp': '0xf5bf',
  'fa-star': '0xf005',
  'fa-star-and-crescent': '0xf699',
  'fa-star-half': '0xf089',
  'fa-star-half-alt': '0xf5c0',
  'fa-star-of-david': '0xf69a',
  'fa-star-of-life': '0xf621',
  'fa-staylinked': '0xf3f5',
  'fa-steam': '0xf1b6',
  'fa-steam-square': '0xf1b7',
  'fa-steam-symbol': '0xf3f6',
  'fa-step-backward': '0xf048',
  'fa-step-forward': '0xf051',
  'fa-stethoscope': '0xf0f1',
  'fa-sticker-mule': '0xf3f7',
  'fa-sticky-note': '0xf249',
  'fa-stop': '0xf04d',
  'fa-stop-circle': '0xf28d',
  'fa-stopwatch': '0xf2f2',
  'fa-stopwatch-20': '0xf96f',
  'fa-store': '0xf54e',
  'fa-store-alt': '0xf54f',
  'fa-store-alt-slash': '0xf970',
  'fa-store-slash': '0xf971',
  'fa-strava': '0xf428',
  'fa-stream': '0xf550',
  'fa-street-view': '0xf21d',
  'fa-strikethrough': '0xf0cc',
  'fa-stripe': '0xf429',
  'fa-stripe-s': '0xf42a',
  'fa-stroopwafel': '0xf551',
  'fa-studiovinari': '0xf3f8',
  'fa-stumbleupon': '0xf1a4',
  'fa-stumbleupon-circle': '0xf1a3',
  'fa-subscript': '0xf12c',
  'fa-subway': '0xf239',
  'fa-suitcase': '0xf0f2',
  'fa-suitcase-rolling': '0xf5c1',
  'fa-sun': '0xf185',
  'fa-superpowers': '0xf2dd',
  'fa-superscript': '0xf12b',
  'fa-supple': '0xf3f9',
  'fa-surprise': '0xf5c2',
  'fa-suse': '0xf7d6',
  'fa-swatchbook': '0xf5c3',
  'fa-swift': '0xf8e1',
  'fa-swimmer': '0xf5c4',
  'fa-swimming-pool': '0xf5c5',
  'fa-symfony': '0xf83d',
  'fa-synagogue': '0xf69b',
  'fa-sync': '0xf021',
  'fa-sync-alt': '0xf2f1',
  'fa-syringe': '0xf48e',
  'fa-table': '0xf0ce',
  'fa-table-tennis': '0xf45d',
  'fa-tablet': '0xf10a',
  'fa-tablet-alt': '0xf3fa',
  'fa-tablets': '0xf490',
  'fa-tachometer-alt': '0xf3fd',
  'fa-tag': '0xf02b',
  'fa-tags': '0xf02c',
  'fa-tape': '0xf4db',
  'fa-tasks': '0xf0ae',
  'fa-taxi': '0xf1ba',
  'fa-teamspeak': '0xf4f9',
  'fa-teeth': '0xf62e',
  'fa-teeth-open': '0xf62f',
  'fa-telegram': '0xf2c6',
  'fa-telegram-plane': '0xf3fe',
  'fa-temperature-high': '0xf769',
  'fa-temperature-low': '0xf76b',
  'fa-tencent-weibo': '0xf1d5',
  'fa-tenge': '0xf7d7',
  'fa-terminal': '0xf120',
  'fa-text-height': '0xf034',
  'fa-text-width': '0xf035',
  'fa-th': '0xf00a',
  'fa-th-large': '0xf009',
  'fa-th-list': '0xf00b',
  'fa-the-red-yeti': '0xf69d',
  'fa-theater-masks': '0xf630',
  'fa-themeco': '0xf5c6',
  'fa-themeisle': '0xf2b2',
  'fa-thermometer': '0xf491',
  'fa-thermometer-empty': '0xf2cb',
  'fa-thermometer-full': '0xf2c7',
  'fa-thermometer-half': '0xf2c9',
  'fa-thermometer-quarter': '0xf2ca',
  'fa-thermometer-three-quarters': '0xf2c8',
  'fa-think-peaks': '0xf731',
  'fa-thumbs-down': '0xf165',
  'fa-thumbs-up': '0xf164',
  'fa-thumbtack': '0xf08d',
  'fa-ticket-alt': '0xf3ff',
  'fa-times': '0xf00d',
  'fa-times-circle': '0xf057',
  'fa-tint': '0xf043',
  'fa-tint-slash': '0xf5c7',
  'fa-tired': '0xf5c8',
  'fa-toggle-off': '0xf204',
  'fa-toggle-on': '0xf205',
  'fa-toilet': '0xf7d8',
  'fa-toilet-paper': '0xf71e',
  'fa-toilet-paper-slash': '0xf972',
  'fa-toolbox': '0xf552',
  'fa-tools': '0xf7d9',
  'fa-tooth': '0xf5c9',
  'fa-torah': '0xf6a0',
  'fa-torii-gate': '0xf6a1',
  'fa-tractor': '0xf722',
  'fa-trade-federation': '0xf513',
  'fa-trademark': '0xf25c',
  'fa-traffic-light': '0xf637',
  'fa-trailer': '0xf941',
  'fa-train': '0xf238',
  'fa-tram': '0xf7da',
  'fa-transgender': '0xf224',
  'fa-transgender-alt': '0xf225',
  'fa-trash': '0xf1f8',
  'fa-trash-alt': '0xf2ed',
  'fa-trash-restore': '0xf829',
  'fa-trash-restore-alt': '0xf82a',
  'fa-tree': '0xf1bb',
  'fa-trello': '0xf181',
  'fa-tripadvisor': '0xf262',
  'fa-trophy': '0xf091',
  'fa-truck': '0xf0d1',
  'fa-truck-loading': '0xf4de',
  'fa-truck-monster': '0xf63b',
  'fa-truck-moving': '0xf4df',
  'fa-truck-pickup': '0xf63c',
  'fa-tshirt': '0xf553',
  'fa-tty': '0xf1e4',
  'fa-tumblr': '0xf173',
  'fa-tumblr-square': '0xf174',
  'fa-tv': '0xf26c',
  'fa-twitch': '0xf1e8',
  'fa-twitter': '0xf099',
  'fa-twitter-square': '0xf081',
  'fa-typo3': '0xf42b',
  'fa-uber': '0xf402',
  'fa-ubuntu': '0xf7df',
  'fa-uikit': '0xf403',
  'fa-umbraco': '0xf8e8',
  'fa-umbrella': '0xf0e9',
  'fa-umbrella-beach': '0xf5ca',
  'fa-underline': '0xf0cd',
  'fa-undo': '0xf0e2',
  'fa-undo-alt': '0xf2ea',
  'fa-uniregistry': '0xf404',
  'fa-unity': '0xf949',
  'fa-universal-access': '0xf29a',
  'fa-university': '0xf19c',
  'fa-unlink': '0xf127',
  'fa-unlock': '0xf09c',
  'fa-unlock-alt': '0xf13e',
  'fa-untappd': '0xf405',
  'fa-upload': '0xf093',
  'fa-ups': '0xf7e0',
  'fa-usb': '0xf287',
  'fa-user': '0xf007',
  'fa-user-alt': '0xf406',
  'fa-user-alt-slash': '0xf4fa',
  'fa-user-astronaut': '0xf4fb',
  'fa-user-check': '0xf4fc',
  'fa-user-circle': '0xf2bd',
  'fa-user-clock': '0xf4fd',
  'fa-user-cog': '0xf4fe',
  'fa-user-edit': '0xf4ff',
  'fa-user-friends': '0xf500',
  'fa-user-graduate': '0xf501',
  'fa-user-injured': '0xf728',
  'fa-user-lock': '0xf502',
  'fa-user-md': '0xf0f0',
  'fa-user-minus': '0xf503',
  'fa-user-ninja': '0xf504',
  'fa-user-nurse': '0xf82f',
  'fa-user-plus': '0xf234',
  'fa-user-secret': '0xf21b',
  'fa-user-shield': '0xf505',
  'fa-user-slash': '0xf506',
  'fa-user-tag': '0xf507',
  'fa-user-tie': '0xf508',
  'fa-user-times': '0xf235',
  'fa-users': '0xf0c0',
  'fa-users-cog': '0xf509',
  'fa-usps': '0xf7e1',
  'fa-ussunnah': '0xf407',
  'fa-utensil-spoon': '0xf2e5',
  'fa-utensils': '0xf2e7',
  'fa-vaadin': '0xf408',
  'fa-vector-square': '0xf5cb',
  'fa-venus': '0xf221',
  'fa-venus-double': '0xf226',
  'fa-venus-mars': '0xf228',
  'fa-viacoin': '0xf237',
  'fa-viadeo': '0xf2a9',
  'fa-viadeo-square': '0xf2aa',
  'fa-vial': '0xf492',
  'fa-vials': '0xf493',
  'fa-viber': '0xf409',
  'fa-video': '0xf03d',
  'fa-video-slash': '0xf4e2',
  'fa-vihara': '0xf6a7',
  'fa-vimeo': '0xf40a',
  'fa-vimeo-square': '0xf194',
  'fa-vimeo-v': '0xf27d',
  'fa-vine': '0xf1ca',
  'fa-virus': '0xf974',
  'fa-virus-slash': '0xf975',
  'fa-viruses': '0xf976',
  'fa-vk': '0xf189',
  'fa-vnv': '0xf40b',
  'fa-voicemail': '0xf897',
  'fa-volleyball-ball': '0xf45f',
  'fa-volume-down': '0xf027',
  'fa-volume-mute': '0xf6a9',
  'fa-volume-off': '0xf026',
  'fa-volume-up': '0xf028',
  'fa-vote-yea': '0xf772',
  'fa-vr-cardboard': '0xf729',
  'fa-vuejs': '0xf41f',
  'fa-walking': '0xf554',
  'fa-wallet': '0xf555',
  'fa-warehouse': '0xf494',
  'fa-water': '0xf773',
  'fa-wave-square': '0xf83e',
  'fa-waze': '0xf83f',
  'fa-weebly': '0xf5cc',
  'fa-weibo': '0xf18a',
  'fa-weight': '0xf496',
  'fa-weight-hanging': '0xf5cd',
  'fa-weixin': '0xf1d7',
  'fa-whatsapp': '0xf232',
  'fa-whatsapp-square': '0xf40c',
  'fa-wheelchair': '0xf193',
  'fa-whmcs': '0xf40d',
  'fa-wifi': '0xf1eb',
  'fa-wikipedia-w': '0xf266',
  'fa-wind': '0xf72e',
  'fa-window-close': '0xf410',
  'fa-window-maximize': '0xf2d0',
  'fa-window-minimize': '0xf2d1',
  'fa-window-restore': '0xf2d2',
  'fa-windows': '0xf17a',
  'fa-wine-bottle': '0xf72f',
  'fa-wine-glass': '0xf4e3',
  'fa-wine-glass-alt': '0xf5ce',
  'fa-wix': '0xf5cf',
  'fa-wizards-of-the-coast': '0xf730',
  'fa-wolf-pack-battalion': '0xf514',
  'fa-won-sign': '0xf159',
  'fa-wordpress': '0xf19a',
  'fa-wordpress-simple': '0xf411',
  'fa-wpbeginner': '0xf297',
  'fa-wpexplorer': '0xf2de',
  'fa-wpforms': '0xf298',
  'fa-wpressr': '0xf3e4',
  'fa-wrench': '0xf0ad',
  'fa-x-ray': '0xf497',
  'fa-xbox': '0xf412',
  'fa-xing': '0xf168',
  'fa-xing-square': '0xf169',
  'fa-y-combinator': '0xf23b',
  'fa-yahoo': '0xf19e',
  'fa-yammer': '0xf840',
  'fa-yandex': '0xf413',
  'fa-yandex-international': '0xf414',
  'fa-yarn': '0xf7e3',
  'fa-yelp': '0xf1e9',
  'fa-yen-sign': '0xf157',
  'fa-yin-yang': '0xf6ad',
  'fa-yoast': '0xf2b1',
  'fa-youtube': '0xf167',
  'fa-youtube-square': '0xf431',
  'fa-zhihu': '0xf63f',
};
